﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using FamilyBudget.ViewModels;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Identity.UI.Services;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.WebUtilities;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Encodings.Web;
using System.Threading.Tasks;

namespace FamilyBudget.Controllers
{
    public class CompteController : Controller
    {
        private readonly ApplicationDbContext _context;
        public CompteController(ApplicationDbContext context)
        {
            _context = context;
        }

        public PartialViewResult LoginPartial()
        {
            return PartialView("_LoginPartial");
        }
        public IActionResult Register()
        {
            return View();
        }

        public IActionResult Login()
        {
            return View();
        }

        [HttpPost]
        public IActionResult Register(RegisterViewModel model)
        {
            if (ModelState.IsValid)
            {
                if (_context.Utilisateurs.Any(u => u.Email == model.Email))
                {
                    ModelState.AddModelError("Email", "Cet email est déjà utilisé.");
                    return View();
                }

                var utilisateur = new Utilisateur
                {
                    Nom = model.Nom,
                    Email = model.Email,
                    MotDePasse = model.MotDePasse
                };

                try
                {
                    _context.Utilisateurs.Add(utilisateur);
                    _context.SaveChanges();
                    HttpContext.Session.SetString("UserName", utilisateur.Nom);
                    HttpContext.Session.SetInt32("IdUtilisateur", utilisateur.IdUtilisateur);
                    return RedirectToAction("Acceuil", "Acceuil");
                }
                catch (DbUpdateException ex)
                {
                    // Vérifier si l'erreur vient du trigger SQL
                    if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                    {
                        ModelState.AddModelError("", sqlEx.Message);
                    }
                    else
                    {
                        ModelState.AddModelError("", "Une erreur s'est produite lors du processus.");
                    }
                }
            }
            return View();
        }

        [HttpPost]
        public IActionResult Login(LoginViewModel model)
        {
            if (ModelState.IsValid)
            {
                var utilisateur = _context.Utilisateurs
                    .FirstOrDefault(u => u.Email == model.Email && u.MotDePasse == model.MotDePasse);

                if (utilisateur == null)
                {
                    ModelState.AddModelError(string.Empty, "Email ou mot de passe incorrect.");
                    return View();
                }
                HttpContext.Session.SetString("UserName", utilisateur.Nom);
                HttpContext.Session.SetInt32("IdUtilisateur", utilisateur.IdUtilisateur);

                
                return RedirectToAction("Acceuil", "Acceuil");
            }

            return View();
        }

        public IActionResult Logout()
        {
            HttpContext.Session.Remove("UserName"); // Supprime seulement le nom
            HttpContext.Session.Clear();
            return RedirectToAction("Login", "Compte");
        }
    }
}
