﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

#nullable disable

namespace FamilyBudget.Models
{
    public partial class Depense
    {
        [Key]
        public int IdDepenses { get; set; }

        [Required(ErrorMessage = "L'utilisateur est obligatoire.")]
        public int IdUtilisateur { get; set; }

        [Required(ErrorMessage = "Le budget est obligatoire.")]
        public int IdBudget { get; set; }

        [Required(ErrorMessage = "Le budget est obligatoire.")]
        public int IdCompte { get; set; }  // Clé étrangère vers Compte

        [Required(ErrorMessage = "Le montant est obligatoire.")]
        [Column(TypeName = "decimal(18,2)")]
        public decimal Montant { get; set; } // Montant de la dépense

        [Required(ErrorMessage = "La date de la depense est obligatoire.")]
        public DateTime DateDepense { get; set; } = DateTime.Now;

        [ForeignKey("IdBudget")]
        public virtual Bugdet IdBudgetNavigation { get; set; }

        [ForeignKey("IdUtilisateur")]
        public virtual Utilisateur IdUtilisateurNavigation { get; set; }

        // Clé étrangère vers Compte
        [ForeignKey("IdCompte")]
        public virtual Compte Compte { get; set; }
        
    }
}
