﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

#nullable disable

namespace FamilyBudget.Models
{
    public partial class Revenu
    {
        [Key]
        public int IdRevenu { get; set; }

        [Required(ErrorMessage = "Le compte est obligatoire.")]
        public int IdCompte { get; set; }

        [Required(ErrorMessage = "La source de revenu est obligatoire.")]
        [StringLength(100, ErrorMessage = "La source de revenu ne peut pas dépasser 100 caractères.")]
        public string SourceRevenu { get; set; }

        [Required(ErrorMessage = "Le montant est obligatoire.")]
        [Column(TypeName = "decimal(18,2)")]
        [Range(0, double.MaxValue, ErrorMessage = "Le montant ne peut pas être négatif.")]
        public decimal Montant { get; set; } // Ajout du montant manquant

        [Required(ErrorMessage = "La date du revenu est obligatoire.")]
        public DateTime DateRevenu { get; set; } = DateTime.Now;

        [ForeignKey("IdCompte")]
        public virtual Compte IdCompteNavigation { get; set; }
    }
}
