﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

#nullable disable

namespace FamilyBudget.Models
{
    public partial class Utilisateur
    {
        public Utilisateur()
        {
            Comptes = new HashSet<Compte>();
            Depenses = new HashSet<Depense>();
            Bugdets = new HashSet<Bugdet>();
        }

        [Key]
        public int IdUtilisateur { get; set; }

        [Required(ErrorMessage = "Le nom est obligatoire.")]
        [StringLength(100, ErrorMessage = "Le nom ne peut pas dépasser 100 caractères.")]
        public string Nom { get; set; }

        [Required(ErrorMessage = "L'email est obligatoire.")]
        [EmailAddress(ErrorMessage = "L'email fourni est invalide.")]
        [StringLength(150, ErrorMessage = "L'email ne peut pas dépasser 150 caractères.")]
        public string Email { get; set; }

        [Required(ErrorMessage = "Le mot de passe est obligatoire.")]
        [StringLength(255, ErrorMessage = "Le mot de passe ne peut pas dépasser 255 caractères.")]
        public string MotDePasse { get; set; }

        public virtual ICollection<Compte> Comptes { get; set; }
        public virtual ICollection<Bugdet> Bugdets { get; set; }
        public virtual ICollection<Depense> Depenses { get; set; }
    }
}
