﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

#nullable disable

namespace FamilyBudget.Models
{
    public partial class Compte
    {
        public Compte()
        {
            Revenus = new HashSet<Revenu>();
            Factures = new HashSet<Facture>();
        }

        [Key]
        public int IdCompte { get; set; }

        [Required(ErrorMessage = "L'utilisateur est obligatoire.")]
        public int IdUtilisateur { get; set; }

        [Required(ErrorMessage = "Le type de compte est obligatoire.")]
        [StringLength(100, ErrorMessage = "Le type de compte ne peut pas dépasser 50 caractères.")]
        public string Type { get; set; }

        [Required(ErrorMessage = "Le solde est obligatoire.")]
        [Column(TypeName = "decimal(18,2)")]
        [Range(1000, 1000000000, ErrorMessage = "Le solde ne doit pas être inferieur a 1000")]
        public decimal Solde { get; set; }

        [ForeignKey("IdUtilisateur")]
        public virtual Utilisateur IdUtilisateurNavigation { get; set; }
        public virtual ICollection<Revenu> Revenus { get; set; }
        public virtual ICollection<Depense> Depenses { get; set; }
        public virtual ICollection<Facture> Factures { get; set; }

    }
}
