﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using FamilyBudget.Services;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;

namespace FamilyBudget.Controllers
{
    public class AcceuilController : Controller
    {

        private readonly ApplicationDbContext _context;

        public AcceuilController(ApplicationDbContext context)
        {
            _context = context;
        }
        public IActionResult Acceuil()
        {
            //// Récupérer les comptes depuis TempData et désérialiser
            //var comptesJson = TempData["Comptes"] as string;
            //var comptes = System.Text.Json.JsonSerializer.Deserialize<List<Compte>>(comptesJson);

            //return View(comptes);
            ////return View(await _context.Comptes.ToListAsync());
            ///
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");

            if (idUtilisateur == null)
            {
                return RedirectToAction("Login", "Compte"); // Rediriger si l'utilisateur n'est pas en session
            }

            var comptes = _context.Comptes
                .FirstOrDefault(c => c.IdUtilisateur == idUtilisateur.Value);

            var totalDepensesUtilisateur = _context.Depenses
            .Where(d => d.Compte.IdUtilisateur == idUtilisateur) // Filtre par utilisateur
            .Sum(d => d.Montant);
            var totalfactureUtilisateur = _context.Factures
            .Where(d => d.Compte.IdUtilisateur == idUtilisateur) // Filtre par utilisateur
            .Sum(d => d.Montant);
            ViewBag.TotalDepenses = totalDepensesUtilisateur;
            ViewBag.Totalfacture = totalfactureUtilisateur;
            return View(comptes);

        }

        public IActionResult Stats()
        {
            return View();
        }

        // Action pour obtenir les données pour le graphique en camembert (Dépenses par compte)
        public async Task<JsonResult> GetDepensesParCompte()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            var depensesParCompte = await _context.Depenses
                .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                .GroupBy(d => d.Compte.Type)
                .Select(group => new
                {
                    Compte = group.Key,
                    Total = group.Sum(d => d.Montant)
                })
                .ToListAsync();

            var labels = depensesParCompte.Select(dp => dp.Compte).ToList();
            var values = depensesParCompte.Select(dp => dp.Total).ToList();

            return Json(new { labels, values });
        }

        public async Task<IActionResult> recap()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            var totalDepenses = await _context.Depenses
                .Where(d => d.IdUtilisateurNavigation.IdUtilisateur == idUtilisateur)
                .SumAsync(d => d.Montant);

            var TotalFactures = await _context.Factures
                .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                .SumAsync(d => d.Montant);

            var moyenneDepense = await _context.Depenses
                .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                .AverageAsync(d => d.Montant);

            ViewBag.TotalDepenses = totalDepenses;
            ViewBag.TotalFactures = TotalFactures;
            ViewBag.MoyenneDepense = moyenneDepense;

            return View();
        }

        // Action pour obtenir les données pour le graphique en barres (Dépenses par mois)
        public async Task<JsonResult> GetDepensesParMois()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            var depensesParMois = await _context.Depenses
                .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                .GroupBy(d => d.DateDepense.Month)
                .Select(group => new
                {
                    Month = group.Key,
                    Total = group.Sum(d => d.Montant)
                })
                .ToListAsync();

            var labels = depensesParMois.Select(dp => dp.Month.ToString()).ToList();
            var values = depensesParMois.Select(dp => dp.Total).ToList();

            return Json(new { labels, values });
        }

        public async Task<IActionResult> Timeline()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            var depenses = await _context.Depenses
                .Include(d => d.IdBudgetNavigation)
                .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                .OrderBy(d => d.DateDepense)
                .ToListAsync();

            return View(depenses);
        }

        // Action pour la recherche dynamique des dépenses
        public async Task<IActionResult> Search(string searchQuery)
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            var depenses = await _context.Depenses
                .Include(d => d.IdBudgetNavigation)
                .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                .Where(d => d.IdBudgetNavigation.Categorie.Contains(searchQuery))
                .ToListAsync();

            return View(depenses);
        }

    }
}
