﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FamilyBudget.Controllers
{
    public class BudgetController : Controller
    {
        //public IActionResult budget()
        //{
        //    return View();
        //}
        private readonly ApplicationDbContext _context;

        public BudgetController(ApplicationDbContext context)
        {
            _context = context;
        }

        public IActionResult budget()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");

            if (idUtilisateur == null)
            {
                return RedirectToAction("Acceuil", "Acceuil"); // Rediriger si l'utilisateur n'est pas en session
            }

            var bugdet = _context.Bugdets
                .Include(c => c.IdUtilisateurNavigation)
                .Where(c => c.IdUtilisateur == idUtilisateur.Value)
                .ToList();
            return View(bugdet);
        }

        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
                return NotFound();

            var budget = await _context.Bugdets
                .Include(c => c.IdUtilisateurNavigation)
                .FirstOrDefaultAsync(m => m.IdBudget == id);

            if (budget == null)
                return NotFound();

            return View(budget);
        }

        public IActionResult Create()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            if (idUtilisateur != 0)
            {
                var utilisateur = _context.Utilisateurs
                                          .Where(u => u.IdUtilisateur == idUtilisateur)
                                          .ToList();

                ViewData["IdUtilisateur"] = new SelectList(utilisateur, "IdUtilisateur", "Nom");
            }
            else
            {
                TempData["ErreurUtilisateur"] = "Utilisateur non connecté ou ID non trouvé.";
                ViewData["IdUtilisateur"] = new SelectList(new List<Utilisateur>(), "IdUtilisateur", "Nom");
            }
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("IdUtilisateur,Categorie,MontantAlloue")] Bugdet budget)
        {
            if (ModelState.IsValid)
            {
                try
                {
                    _context.Add(budget);
                    await _context.SaveChangesAsync();
                    return RedirectToAction("Budget", "budget");
                }
                catch (DbUpdateException ex)
                {
                    // Vérifier si l'erreur vient du trigger SQL
                    if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                    {
                        ModelState.AddModelError("", sqlEx.Message);
                    }
                    else
                    {
                        ModelState.AddModelError("", "Une erreur s'est produite lors de l'ajout du budget.");
                    }
                }
                
            }
            ViewData["IdUtilisateur"] = new SelectList(_context.Utilisateurs, "IdUtilisateur", "Nom", budget.IdUtilisateur);
            return View(budget);
        }

        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var budget = await _context.Bugdets.FindAsync(id);
            if (budget == null)
            {
                return NotFound();
            }

            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            if (idUtilisateur != 0)
            {
                var utilisateur = _context.Utilisateurs
                                          .Where(u => u.IdUtilisateur == idUtilisateur)
                                          .ToList();

                ViewData["IdUtilisateur"] = new SelectList(utilisateur, "IdUtilisateur", "Nom");
            }
            else
            {
                TempData["ErreurUtilisateur"] = "Utilisateur non connecté ou ID non trouvé.";
                ViewData["IdUtilisateur"] = new SelectList(new List<Utilisateur>(), "IdUtilisateur", "Nom");
            }

            return View(budget);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("IdBudget,IdUtilisateur,Categorie,MontantAlloue")] Bugdet budget)
        {
            if (id != budget.IdBudget)
            {
                return NotFound();
            }

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(budget);
                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!BudgetExists(budget.IdBudget))
                    {
                        ModelState.AddModelError("", "Une erreur s'est produite lors de l'edition du budget. Budget inexistants");
                    }
                    else
                    {
                        throw;
                    }
                }
                return RedirectToAction("Budget", "budget");
            }
            ViewData["IdUtilisateur"] = new SelectList(_context.Utilisateurs, "IdUtilisateur", "Nom", budget.IdUtilisateur);
            return View(budget);
        }

        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
            {
                return NotFound();
            }

            var budget = await _context.Bugdets
                .Include(c => c.IdUtilisateurNavigation)
                .FirstOrDefaultAsync(m => m.IdBudget == id);
            if (budget == null)
            {
                return NotFound();
            }

            return View(budget);
        }

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public IActionResult DeleteConfirmed(int id)
        {
            var budget = _context.Bugdets
                .Include(b => b.Depenses)
                .FirstOrDefault(b => b.IdBudget == id);

            if (budget == null)
            {
                return NotFound();
            }

            // Récupérer l'ID de la première dépense associée (s'il y en a)
            var depense = budget.Depenses.FirstOrDefault();

            try
            {
                if (depense != null)
                {
                    return RedirectToAction("Delete", "Depense", new { id = depense.IdDepenses });
                }

                // Supprimer le budget si aucune dépense n'est trouvée
                _context.Bugdets.Remove(budget);
                _context.SaveChanges();

                return RedirectToAction("Budget", "Budget");
            }
            catch (DbUpdateException ex)
            {
                // Vérifier si l'erreur vient du trigger SQL
                if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                {
                    ModelState.AddModelError("", sqlEx.Message);
                }
                else
                {
                    ModelState.AddModelError("", "Une erreur s'est produite lors de la suppression du budget.");
                }
            }
            return View(budget);
            
        }


        private bool BudgetExists(int id)
        {
            return _context.Bugdets.Any(e => e.IdBudget == id);
        }
    }
}
