﻿using FamilyBudget.Data;
using FamilyBudget.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Rendering;
using Microsoft.Data.SqlClient;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FamilyBudget.Controllers
{
    public class FactureController : Controller
    {
        //public IActionResult facture()
        //{
        //    return View();
        //}

        private readonly ApplicationDbContext _context;

        public FactureController(ApplicationDbContext context)
        {
            _context = context;
        }

        public async Task<IActionResult> facture()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");

            return View(await _context.Factures
                                            .Include(d =>d.Compte)
                                            .Where(d => d.Compte.IdUtilisateur == idUtilisateur)
                                            .ToListAsync());
        }

        public async Task<IActionResult> Details(int? id)
        {
            if (id == null)
                return NotFound();

            var facture = await _context.Factures.Include(d => d.Compte).FirstOrDefaultAsync(m => m.IdFacture == id);
            if (facture == null)
                return NotFound();

            return View(facture);
        }

        public IActionResult Create()
        {
            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            ViewData["IdCompte"] = new SelectList(_context.Comptes
            .Where(c => c.IdUtilisateur == idUtilisateur.Value),
                "IdCompte", "Type");
            return View();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Create([Bind("IdCompte,CategorieFacture,Montant,DateFacture")] Facture facture)
        {
            if (ModelState.IsValid)
            {
                try
                {
                    _context.Add(facture);

                    var compte = await _context.Comptes.FindAsync(facture.IdCompte);
                    if (compte != null)
                    {
                        if (compte.Solde < facture.Montant)
                        {
                            ViewBag.Message = "Le solde de votre compte est Insuffisant";
                            return View();
                        }
                        else
                        {
                            compte.Solde -= facture.Montant; // On soustrait le montant de la dépense
                            _context.Update(compte);
                        }

                    }

                    await _context.SaveChangesAsync();
                    return RedirectToAction("facture", "Facture");
                }
                catch (DbUpdateException ex)
                {
                    // Vérifier si l'erreur vient du trigger SQL
                    if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                    {
                        ModelState.AddModelError("", sqlEx.Message);
                    }
                    else
                    {
                        ModelState.AddModelError("", "Une erreur s'est produite lors de l'ajout de la facture.");
                    }
                }

                
            }
            return View(facture);
        }

        public async Task<IActionResult> Edit(int? id)
        {
            if (id == null)
                return NotFound();

            var facture = await _context.Factures.FindAsync(id);
            if (facture == null)
                return NotFound();

            var idUtilisateur = HttpContext.Session.GetInt32("IdUtilisateur");
            ViewData["IdCompte"] = new SelectList(_context.Comptes
                                                            .Where(c => c.IdUtilisateur == idUtilisateur.Value),
                                                             "IdCompte", "Type");
            return View(facture);
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> Edit(int id, [Bind("IdFacture,IdCompte,CategorieFacture,Montant,DateFacture")] Facture facture)
        {
            if (id != facture.IdFacture)
                return NotFound();

            if (ModelState.IsValid)
            {
                try
                {
                    _context.Update(facture);

                    var compte = await _context.Comptes.FindAsync(facture.IdCompte);
                    if (compte != null)
                    {
                        if (compte.Solde < facture.Montant)
                        {
                            ViewBag.Message = "Le solde de votre compte est Insuffisant";
                            return View();
                        }
                        else
                        {
                            compte.Solde -= facture.Montant; // On soustrait le montant de la dépense
                            _context.Update(compte);
                        }

                    }

                    await _context.SaveChangesAsync();
                }
                catch (DbUpdateConcurrencyException)
                {
                    if (!_context.Factures.Any(e => e.IdFacture == facture.IdFacture))
                        ModelState.AddModelError("", "Une erreur s'est produite lors de l'edition de la facture.");
                    else
                        throw;
                }
                return RedirectToAction("facture", "Facture");
            }
            return View(facture);
        }

        public async Task<IActionResult> Delete(int? id)
        {
            if (id == null)
                return NotFound();

            var facture = await _context.Factures
                .Include(d => d.Compte)
                .FirstOrDefaultAsync(m => m.IdFacture == id);
            if (facture == null)
                return NotFound();

            return View(facture);
        }

        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public async Task<IActionResult> DeleteConfirmed(int id)
        {
            var facture = await _context.Factures.FindAsync(id);

            try
            {
                var compte = await _context.Comptes.FindAsync(facture.IdCompte);
                if (compte != null)
                {
                    compte.Solde += facture.Montant; // On restitue le montant au compte
                    _context.Update(compte);
                }

                _context.Factures.Remove(facture);
                await _context.SaveChangesAsync();
                return RedirectToAction("facture", "Facture");
            }
            catch (DbUpdateException ex)
            {
                // Vérifier si l'erreur vient du trigger SQL
                if (ex.InnerException is SqlException sqlEx) // Code d'erreur du THROW SQL Server
                {
                    ModelState.AddModelError("", sqlEx.Message);
                }
                else
                {
                    ModelState.AddModelError("", "Une erreur s'est produite lors de l'ajout du livre.");
                }
            }
            return View(facture);
        }
    }
}
